/***********************************************************************************************************************
* File Name     : MMR920.h
* Version        : 1.0.0.0
* Device(s)     : Arduino UNO/DUE/...
* Description   : MMR920 setting Header File
***********************************************************************************************************************/
/**********************************************************************************************************************
* History : DD.MM.YYYY Version  Description
*         : 07.10.2024 1.0.0.0  First Release
***********************************************************************************************************************/
#ifndef _MMR920_
#define _MMR920_

// do not change
char model_name[6] = {'M','M','R','9','2','0'};        // Sensor model name

//==============================================================================
// DEFINES AND MACROS
//==============================================================================
// do not change
#define SLAVE_ADDR (uint8_t)0x67    // MMR920 I2C Slave Address

// do not change
// Pressure sensor activate command
#define CMD_ACTIVE1 0xA0            // Active Mode 1
#define CMD_ACTIVE2 0xA2            // Active Mode 2
#define CMD_ACTIVE3 0xA4            // Active Mode 3
#define CMD_ACTIVE4 0xA6            // Active Mode 4

// do not change
// 1st wait time(When measuring with a timer)
#define ACTIVE1_1ST_WAITTIME    3100        // Active1: wait(max.=3.1ms)
#define ACTIVE2_1ST_WAITTIME    6100        // Active2: wait(max.=6.1ms)
#define ACTIVE3_1ST_WAITTIME    12200       // Active3: wait(max.=12.2ms)
#define ACTIVE4_1ST_WAITTIME    24300       // Active4: wait(max.=24.3ms)

// ACTIVEX_LPFFC_MACRAM = 2^27 × exp (−2𝜋 × fc / fs)   fc:Cutoff Frequency[Hz](user setting)   fs:Sampling Frequency[Hz]
#define ACTIVE1_LPFFC_MACRAM    105006934   // Active1 fc:100[Hz]   fs = 2560[Hz]
#define ACTIVE2_LPFFC_MACRAM    82153501    // Active2 fc:100[Hz]   fs = 1280[Hz]
#define ACTIVE3_LPFFC_MACRAM    50285442    // Active3 fc:100[Hz]   fs = 640[Hz]
#define ACTIVE4_LPFFC_MACRAM    18839729    // Active4 fc:100[Hz]   fs = 320[Hz]

//==============================================================================
// VARIABLES(User setting)
//==============================================================================
// DRDYB Flag
boolean DRDYB_measureFlag = true;   // true:Measure with DRDYB    false:Measure with timer(us)

// Interval setting (Not applicable when measure with DRDYB)
// Active Mode1, Active Mode2 are not supported
uint32_t waitTime = 1604;           // Active1: wait(max.=0.401ms=401us)   Active2: wait(max.=0.802ms=802us) 
                                    // Active3: wait(max.=1.604ms=1604us)  Active4: wait(max.=3.208ms=3208us)
                                
// Active mode   (when using app, set active mode in app.)
// Active Mode1, Active Mode2 are not supported
uint8_t activeCmd = CMD_ACTIVE3;    // Active Mode1~4 setting (Stand alone only)

// Skip Number
uint8_t skipNum = 0;                // Number of times to skip reading data

// Read result flag
boolean result1Flag = false;        // read pressure result          true:read  false:no read
boolean result2Flag = false;        // read temperature result       true:read  false:no read
boolean result3Flag = true;         // read pressure 1st Lpf result  true:read  false:no read
boolean result4Flag = false;        // MMR920 Not support

#endif // _MMR920_
