/***********************************************************************************************************************
* File Name     : command.h
* Version	    : 1.0.0.0
* Device(s)     : Arduino UNO/DUE/...
* Description   : Pressure sensor command process Header File
***********************************************************************************************************************/
/**********************************************************************************************************************
* History : DD.MM.YYYY Version	Description
*         : 07.10.2024 1.0.0.0	First Release
***********************************************************************************************************************/
#ifndef _CMD_
#define _CMD_

//==============================================================================
// DEFINES AND MACROS for Arduino Settings
//==============================================================================
// command set from Arduino IDE (Serial Monitor/Serial Plotter)
#define IDE_CMD_START           'S'         // Measurement start
#define IDE_CMD_START2          's'         // Measurement start
#define IDE_CMD_STOP            'P'         // Measurement stop
#define IDE_CMD_STOP2           'p'         // Measurement stop


// command set from Evaluation Program(Application)
#define APP_CMD_INST                    'T'         // Instruction code
#define APP_CMD_SELECT_BOARD            0x10        // Select board command fromapplication
#define APP_CMD_SELECT_PROTOCOL         0x12        // Select protocol command from application
#define APP_CMD_SET_SLA                 0x13        // Set slave address command from application 
#define APP_CMD_VERSION                 0x15        // Read firmware version command from application
#define APP_CMD_START                   0x23        // Start command from application
#define APP_CMD_READ_PROTOCOL           0x32        // Read protocol command from application
#define APP_CMD_STOP                    0x33        // Stop command from application
#define APP_CMD_READ_MODEL              0xA6        // Stop command from application

#define ERROR_CODE_NO_ERROR             0x00        // No Error
#define ERROR_CODE_ILLEGAL_PARAMETER    0x03        // Illegal Parameter
#define ERROR_CODE_NOT_SUPPORT          0x10        // Command not support

//==============================================================================
// VARIABLES
//==============================================================================
// Response data
uint8_t response_data[8];               // errorcode(1byte) + datalength(1byte) + responsedata(6byte)
uint8_t reaponseDataLength = 6;                   // 3byte:result data  3byte:waittime data

#endif // _CMD_
