/***********************************************************************************************************************
* File Name     : config.h
* Version	    : 1.0.0.0
* Device(s)     : Arduino UNO/DUE/...
* Description   : config Header File
***********************************************************************************************************************/
/**********************************************************************************************************************
* History : DD.MM.YYYY VersionS	Description
*         : 07.10.2024 1.0.0.0	First Release
***********************************************************************************************************************/
#ifndef _CFG_
#define _CFG_

//==============================================================================
// INCLUDES
//==============================================================================
// do not change
#include "MMR920.h"

//==============================================================================
// SAMPLE SKETCH VERSION
//==============================================================================
// do not change
char sketch_version[4] = {'1','0','0','0'};        // Sketch release version

//==============================================================================
// PSEL SETTING
//==============================================================================
// do not change
uint8_t psel = 0;           // I2C : 0  SPI : 1

//==============================================================================
// DEFINES AND MACROS
//==============================================================================
#define UNO           1
#define DUE           2
#define LEONARDO      3
#define MEGA2560      4
#define ARDUINO_VER   UNO       // set arduino board

#if(ARDUINO_VER == UNO)
    #define WIRE Wire
    #define CSB 7
    #define PSEL 6
    #define SPI_EN 5
    #define I2C_EN 4
    #define DRDYB 3
#elif(ARDUINO_VER == DUE)
    #define WIRE Wire1
    #define CSB 7
    #define PSEL 6
    #define SPI_EN 5
    #define I2C_EN 4
    #define DRDYB 3
#elif(ARDUINO_VER == LEONARDO)
    #define WIRE Wire
    #define CSB 7
    #define PSEL 6
    #define SPI_EN 5
    #define I2C_EN 4
    #define DRDYB 3
#elif(ARDUINO_VER == MEGA2560)
    #define WIRE Wire
    #define CSB 7
    #define PSEL 6
    #define SPI_EN 5
    #define I2C_EN 4
    #define DRDYB 3
#else
    #define WIRE Wire
    #define CSB 7
    #define PSEL 6
    #define SPI_EN 5
    #define I2C_EN 4
    #define DRDYB 3
#endif

// Log Separater
char sep[2] = ",";


#endif // _CFG_
